#version 330
#extension GL_EXT_gpu_shader4 : enable
// noisey color journeyMod01.fsh  by   SimonOakey

//https://www.shadertoy.com/view/ss2GW3
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*licenced under love, peace and happyness ✌️ */

/*
#ifdef GL_ES
precision mediump float;
#endif
*/
 


 //generic rotation formula
vec2 rot(vec2 uv,float a){
	return vec2(uv.x*cos(a)-uv.y*sin(a),uv.y*cos(a)+uv.x*sin(a));
}



vec3 returnGrain(vec2 _uv, float amount){
	
	 float x = (_uv.x + 4.0 ) * (_uv.y + 4.0 ) * (iTime * 10.0);
	 vec4 grain = vec4(mod((mod(x, 13.0) + 1.0) * (mod(x, 123.0) + 1.0), 0.01)-0.005) *  amount;
	 return grain.xyz;
	
}


float rand(vec2 n) { 
    return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}

float noise(vec2 p){
    vec2 ip = floor(p);
    vec2 u = fract(p);
    u = u*u*(3.0-2.0*u);

    float res = mix(
        mix(rand(ip),rand(ip+vec2(1.0,0.0)),u.x),
        mix(rand(ip+vec2(0.0,1.0)),rand(ip+vec2(1.0,1.0)),u.x),u.y);
    return res*res;
}

const mat2 mtx = mat2( 0.80,  0.60, -0.60,  0.80 );

float fbm( vec2 p )
{
    float f = 0.0;
/*
    vec2 p1 = vec2(p.x*.6,p.y*.6 + time*.12);
    f += 0.500000*noise( p1); p1 = mtx*p1*3.03;
	
   
	vec2 p2 = vec2(p.x*1.6 + time*.3 ,p.y*2.6 );
    f += 0.300000*noise( p2); 
	
	
	vec2 p3 = vec2(p.x*3.6 - time*.6 ,p.y*6.6 );
    f += 0.200000*noise( p3);
	
 vec2 p4 = vec2(p.x*13.6 - time*.6 ,p.y*16.6 );
    f += 0.200000*noise( p4);
	*/
	
    
     //p.x *= texture(iChannel1, p).x*1.2;
     //p.y *= texture(iChannel1, p).y*1.2;
    
	
	for(int i=0;i<11; i++){

	vec2 p1 = vec2(p.x*.4*float(i),p.y*.4*float(i));
		
	p1.x *=	noise(p1*.5+iTime*.1)*.4;
	p1.y *=	noise(p*.5-iTime*.1)*.4;
    
    
		
    	f += 0.8*noise(p1); p1 = mtx*p1*3.03;	
		
	
	}
	

    return f;
}

float pattern( in vec2 p )
{
	return fbm( p + fbm( p*2.3 + fbm( p*.33 ) ) );
}



vec3 hsv2rgb( in vec3 c )
{
    vec3 rgb = clamp( abs(mod(c.x*6.0+vec3(0.0,4.0,2.0),6.0)-3.0)-1.0, 0.0, 1.0 );
    return c.z * mix( vec3(1.0), rgb, c.y);
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{

	float _x = iMouse.x;

	vec2 uv = gl_FragCoord.xy/iResolution.y;
	
	//uv.x = sin(uv.x*5.);
	
	uv.x += iResolution.y/iResolution.x;
	
	uv = rot(uv,iTime*.03);
	
	float shade = pattern(uv);
	
	
	
	vec3 col = vec3(
		sin(shade*.91+ iTime*.01)*1.75+.5 ,
		cos(shade*3.+ iTime*.13)*.75+.5 ,
		cos(shade*13.+ iTime*.13)*.5+.6 
			//shade*.7+.4
	);
	
	col = hsv2rgb(col);
	
	col += returnGrain(uv,9.);
	
	gl_FragColor = vec4( col, 1.0 );

}




 